/*
 * EffectInfoCollection.h
 *
 * Created 9/2/2009 By Johnny Huynh
 *
 * Version 00.00.01 9/2/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef EFFECT_INFO_COLLECTION_H
 #define EFFECT_INFO_COLLECTION_H
 
 template <typename T> class EffectInfoCollection;
 
 #include "global.h"
 
 #include "EffectInfo.h"
 #include "pointerTo.h"
 #include <list>
 
 /**
  * Class specification for EffectInfoCollection
  */
 template <typename T>
 class EffectInfoCollection : private std::list<PT(EffectInfo<T>)>
 {
 // Public Encapsulated Classes
 public:
    class iterator;
 
 // Data Members
 protected:
 typedef std::list<PT(EffectInfo<T>)> std_list;
    
 // Local Functions
 public:
    EffectInfoCollection();
    EffectInfoCollection( const EffectInfoCollection<T>& effect_info_collection );
    virtual ~EffectInfoCollection();
    inline EffectInfoCollection<T>& operator=( const EffectInfoCollection<T>& effect_info_collection );
    inline void add( EffectInfo<T>* effect_info_Ptr );
    inline typename EffectInfoCollection<T>::iterator begin();
    inline typename EffectInfoCollection<T>::iterator end();
    inline void clear();
    inline EffectInfo<T>* get_front();
    inline void remove_front();
    inline size_t size() const;
 
 // Private Functions
 private:
    
 // Public Static Functions
 public:
 
 // Public Encapsulated Classes
 public:
    /**
     *  Class specification for ListCollection<T>::iterator
     */
    virtual class iterator
    {
    friend class EffectInfoCollection<T>; // for invoking private functions
    
    // Data members
    private:
        typename std_list::iterator _value_Itr;
    
    // Local Functions
    public:
        iterator() { }
        iterator( const iterator& itr ) : _value_Itr( itr._value_Itr ) { }
        ~iterator() { }
        inline iterator& operator=( const iterator& itr ) { _value_Itr = itr._value_Itr; return *this; }
        inline bool operator==( const iterator& itr ) { return _value_Itr == itr._value_Itr; }
        inline bool operator!=( const iterator& itr ) { return _value_Itr != itr._value_Itr; }
        inline PT(EffectInfo<T>)& operator*() const { return *this->_value_Itr; } // dereference operator
        inline PT(EffectInfo<T>)& operator->() const { return *this->_value_Itr; } // member access operator
        inline iterator& operator++() { ++_value_Itr; return *this; } // post-increment
        inline iterator& operator++(int) { ++_value_Itr; return *this; } // pre-increment
        inline iterator& operator--() { --_value_Itr; return *this; } // post-decrement
        inline iterator& operator--(int) { --_value_Itr; return *this; } // pre-decrement
        
    // Private Functions
    private:
        iterator( const typename std_list::iterator& value_Itr ) : _value_Itr( value_Itr ) { }
    };
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 EffectInfoCollection<T>::EffectInfoCollection()
                         : std_list()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 EffectInfoCollection<T>::EffectInfoCollection( const EffectInfoCollection<T>& effect_info_collection )
                         : std_list( effect_info_collection )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 EffectInfoCollection<T>::~EffectInfoCollection()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified EffectInfoCollection to this EffectInfoCollection.
  *
  * @param (const EffectInfoCollection<T>&) effect_info_collection
  * @return EffectInfoCollection<T>&
  */
 template <typename T>
 inline EffectInfoCollection<T>& EffectInfoCollection<T>::operator=( const EffectInfoCollection<T>& effect_info_collection )
 {
    std_list::operator=( effect_info_collection );
    
    return *this;
 }
 
 /**
  * add() adds the specified value to this collection.
  *
  * @param (EffectInfo<T>*) effect_info_Ptr
  */
 template <typename T>
 inline void EffectInfoCollection<T>::add( EffectInfo<T>* effect_info_Ptr )
 {
    std_list::push_back( effect_info_Ptr );
 }
 
 /**
  * begin() returns the beginning iterator of this collection.
  *
  * @return EffectInfoCollection<T>::iterator
  */
 template <typename T>
 inline typename EffectInfoCollection<T>::iterator EffectInfoCollection<T>::begin()
 {
    return std_list::begin();
 }
 
 /**
  * end() returns the ending iterator of this collection.
  *
  * @return EffectInfoCollection<T>::iterator
  */
 template <typename T>
 inline typename EffectInfoCollection<T>::iterator EffectInfoCollection<T>::end()
 {
    return std_list::end();
 }
 
 /**
  * clear() removes all values from this collection.
  */
 template <typename T>
 inline void EffectInfoCollection<T>::clear()
 {
    std_list::clear();
 }
 
 /**
  * get_front() returns the first value in this collection.
  *
  * @return EffectInfo<T>*
  */
 template <typename T>
 inline EffectInfo<T>* EffectInfoCollection<T>::get_front()
 {
    return std_list::front();
 }
 
 /**
  * remove_front() removes the first value from this collection.
  */
 template <typename T>
 inline void EffectInfoCollection<T>::remove_front()
 {
    std_list::pop_front();
 }
 
 /**
  * size() returns the number of values in this collection.
  *
  * @return size_t
  */
 template <typename T>
 inline size_t EffectInfoCollection<T>::size() const
 {
    return std_list::size();
 }
 
 /** PUBLIC STATIC FUNCTIONS **/
 
 #endif // EFFECT_INFO_COLLECTION_H